package app.firezone.synk.network.Adapter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;

import app.firezone.synk.network.Fragments.LotteryResultFragment;
import app.firezone.synk.network.Fragments.LotteryUpcomingFragment;


public class LotteryTabAdapter extends FragmentPagerAdapter {


    public LotteryTabAdapter(@NonNull FragmentManager fm) {
        super(fm);
    }

    @NonNull
    @Override
    public Fragment getItem(int position) {
        switch (position){
            case 0: return  new LotteryUpcomingFragment();
            case 1: return  new LotteryResultFragment();
            default: return  new LotteryUpcomingFragment();
        }
    }

    @Nullable
    @Override
    public CharSequence getPageTitle(int position) {

        switch (position){
            case 0: return  "Upcoming";
            case 1: return "Result";
            default: return  "Upcoming";
        }

    }

    @Override
    public int getCount() {
        return 2;
    }
}
